#include <bits/stdc++.h>
using namespace std;

struct Node {
    array<Node*,10> ch;
    vector<long long> ends;
    Node(){ ch.fill(nullptr); }
};

void insertNode(Node* root, const string &s, long long val){
    Node* cur = root;
    for(char c: s){
        int d = c - '0';
        if(!cur->ch[d]) cur->ch[d] = new Node();
        cur = cur->ch[d];
    }
    cur->ends.push_back(val);
}

void collect(Node* node, vector<long long>& out){
    if(!node) return;
    for(long long v: node->ends) out.push_back(v);
    for(int d=0; d<10; ++d) if(node->ch[d]) collect(node->ch[d], out);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if(!(cin>>n)) return 0;
    vector<long long> a(n);
    for(int i=0;i<n;++i) cin>>a[i];

    Node* root = new Node();
    for(long long x: a) insertNode(root, to_string(x), x);

    vector<vector<long long>> groups;
    // for each child of root, collect entire subtree -> one group
    for(int d=0; d<10; ++d){
        if(root->ch[d]){
            vector<long long> g;
            collect(root->ch[d], g);
            if(!g.empty()) groups.push_back(g);
        }
    }
    // Also handle numbers that are at root (the number "0" if present) — not possible here (ai>=1)
    cout << groups.size() << '\n';
    for(auto &g: groups){
        cout << g.size() << '\n';
        for(size_t i=0;i<g.size();++i){
            if(i) cout << ' ';
            cout << g[i];
        }
        cout << '\n';
    }
    return 0;
}